#!/bin/sh

# Replicant USB Networking
# ========================                             
# 
# Copyright (C) 2011 Paul Kocialkowski, GPLv3+
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

IPTABLES_CLEAN_RULES=true

USB_IFACE="usb0" 
INTERNET_IFACE="eth0" 

USB_IFACE_IP="192.168.4.200" 

# Clean iptables rules

iptables_rules_clean () {
    if [ $IPTABLES_CLEAN_RULES = false ]
    then
        return
    fi

    iptables --flush
    iptables --table nat --flush
    iptables --delete-chain
    iptables --table nat --delete-chain
}

# Inject iptables forwarding rules

iptables_forward_rules_apply () {
    iptables --table nat --append POSTROUTING --out-interface $INTERNET_IFACE -j MASQUERADE
    iptables --append FORWARD --in-interface $USB_IFACE -j ACCEPT
    echo 1 > /proc/sys/net/ipv4/ip_forward 
}

# Configure network link

usb_networking_configure () {
    ifconfig $USB_IFACE up
    ifconfig $USB_IFACE $USB_IFACE_IP
}

usb_networking_disable () {
    ifconfig $USB_IFACE down
    echo 0 > /proc/sys/net/ipv4/ip_forward 
}

case $1 in
    "start")
        echo "Starting Replicant USB Networking" 
        iptables_rules_clean
        usb_networking_configure
        iptables_forward_rules_apply
    ;;
    "stop")
        echo "Stopping Replicant USB Networking" 
        usb_networking_disable
        iptables_rules_clean
    ;;
    *)
        echo "Usage: sh $0 {start|stop}" 
    ;;
esac
